const { Spinner } = wp.components
const { __ } = wp.i18n; // Import __() from wp.i18n

const buttonRender = ({attributes, loading}) => {
	const buttonTypeClass = attributes.metaStyle.type == "round" ? "wa__r_button" : "wa__sq_button";
    const isOnline = true;
    const buttonStatus = isOnline ? 'wa__stt_online' : 'wa__stt_offline'
	const avatarClass = attributes.imageUrl ? "wa__btn_w_img" : "wa__btn_w_icon";
    const avatarStyle = {
		backgroundImage: `url(${attributes.imageUrl})`,
		backgroundSize: 'cover',
		backgroundPosition: 'center center',
		backgroundRepeat : 'no-repeat'
	}
    const avatarOrIconContent = attributes.imageUrl ? (
		<div className="wa__cs_img">
			<div 
				className="wa__cs_img_wrap"
				style={avatarStyle} 
			/>
		</div>
	) : (
		<div className="wa__btn_icon">
			<img alt="img" src={njtwa.avatarDefaultUrl} />
		</div>
	);
	const nameStyle = {
		color: (attributes.metaStyle.textColor =='#fff' || attributes.metaStyle.textColor == '#ffffff') ? '#d5f0d9' : attributes.metaStyle.textColor, 
		opacity: (attributes.metaStyle.textColor =='#fff' || attributes.metaStyle.textColor == '#ffffff') ? 1 : 0.8
	}
    const titleContent = attributes.metaInfo.title ? ( 
		<div className="wa__cs_info">
			<div
				className="wa__cs_name"
				style={nameStyle}
			>
				{attributes.metaInfo.title}
			</div>
			<div 
				className="wa__cs_status"
			>
				{isOnline ? __("Online", "ninjateam-whatsapp") : __("Offline", "ninjateam-whatsapp")}
			</div>
		</div>
	) : null;
    return (
        loading ? 
        <div className="components-disabled">
            <div className="components-placeholder is-large"><Spinner/></div>
        </div> : 
        <div className={`wa__button ${buttonTypeClass} ${buttonStatus} ${avatarClass}`} 
			style={{backgroundColor: attributes.metaStyle.backgroundColor}}
		>
            { avatarOrIconContent }
            <div className="wa__btn_txt">
                {titleContent}
                <div 
					className="wa__btn_title" 
					style={{color: attributes.metaStyle.textColor}}
				>
					{attributes.metaStyle.label}
				</div>
                {isOnline ? null : (<div className="wa__btn_status">Offline text</div>)}
            </div>
        </div>
    )
}

export default buttonRender