const { MediaUpload, MediaUploadCheck } = wp.blockEditor;
const { ResponsiveWrapper, Button, Spinner } = wp.components;
const { withSelect } = wp.data;
const { __ } = wp.i18n; // Import __() from wp.i18n

const mediaSelect = ({ attributes, setAttributes, media }) => {
	const removeMedia = () => {
		setAttributes({
			imageID: "",
			imageUrl: "",
			imageAlt: "img"
		});
	};

	const onSelectMedia = media => {
		setAttributes({
			imageID: media.id,
			imageUrl: media.url,
			imageAlt: media.alt_text
		});
	};
	return (
		<div className="editor-post-featured-image">
			<MediaUploadCheck>
				<MediaUpload
					onSelect={onSelectMedia}
					value={attributes.imageID}
					allowedTypes={["image"]}
					render={({ open }) => (
						<Button
                            style={{position: 'relative', height: !media ? 36 : 'auto'}}
							className={
								attributes.imageID == 0
									? "wa-blocks editor-post-featured-image__toggle"
									: "wa-blocks editor-post-featured-image__preview"
							}
							onClick={open}
						>
							{attributes.imageID == 0 && __("Choose an image", "ninjateam-whatsapp")}
                            {(attributes.imageID && !media) ? <Spinner/> : null }
							{media != undefined && (
								<ResponsiveWrapper
									naturalWidth={media.media_details.width}
									naturalHeight={media.media_details.height}
								>
									<img src={media.source_url} alt={media.alt_text} />
								</ResponsiveWrapper>
							)}
						</Button>
					)}
				/>
			</MediaUploadCheck>
			{attributes.imageID != 0 && (
				<MediaUploadCheck>
					<MediaUpload
						title={__("Replace image", "ninjateam-whatsapp")}
						value={attributes.imageID}
						onSelect={onSelectMedia}
						allowedTypes={["image"]}
						render={({ open }) => (
							<Button onClick={open} isSecondary isLarge>
								{__("Replace image", "ninjateam-whatsapp")}
							</Button>
						)}
					/>
				</MediaUploadCheck>
			)}
			{attributes.imageID != 0 && (
				<MediaUploadCheck>
					<Button onClick={removeMedia} isLink isDestructive>
						{__("Remove image", "ninjateam-whatsapp")}
					</Button>
				</MediaUploadCheck>
			)}
		</div>
	);
};

export default withSelect((select, ownProps) => {
	return {
		media: select("core").getMedia(ownProps.attributes.imageID)
	}
})(mediaSelect);

